/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class LunarForecast {
    protected final Level level;
    protected final Holder<LunarDimensionSettings> dimensionSettingsHolder;
    protected final List<LunarEventInstance> forecast = new ArrayList<LunarEventInstance>();
    protected final List<LunarEventInstance> pastEvents = new ArrayList<LunarEventInstance>();
    protected final Object2ObjectOpenHashMap<Holder<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirements = new Object2ObjectOpenHashMap();
    protected long lastCheckedDay = -1L;
    private Holder<LunarEvent> lastTickEvent;
    private Holder<LunarEvent> lastStoredEvent;
    protected float blend = 1.0f;

    public LunarForecast(Level level, Holder<LunarDimensionSettings> lunarDimensionSettingsHolder) {
        this.level = level;
        this.dimensionSettingsHolder = lunarDimensionSettingsHolder;
        Registry lunarEvents = (Registry)level.m_9598_().m_6632_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
        for (Map.Entry resourceKeyLunarEventEntry : lunarEvents.m_6579_()) {
            LunarEvent.SpawnRequirements spawnRequirements;
            Holder.Reference lunarEventHolder = lunarEvents.m_246971_((ResourceKey)resourceKeyLunarEventEntry.getKey());
            ResourceKey levelResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceKey)this.dimensionSettingsHolder.m_203543_().orElseThrow()).m_135782_());
            Map<ResourceKey<Level>, LunarEvent.SpawnRequirements> eventChancesByDimension = ((LunarEvent)lunarEventHolder.m_203334_()).getEventChancesByDimension();
            if (!eventChancesByDimension.containsKey(levelResourceKey) || !((spawnRequirements = eventChancesByDimension.get(levelResourceKey)).chance() > 0.0) || spawnRequirements.validMoonPhases().isEmpty() || spawnRequirements.minNumberOfNights() < 0) continue;
            this.lunarEventSpawnRequirements.put((Object)lunarEventHolder, (Object)spawnRequirements);
        }
        this.lastTickEvent = this.currentLunarEvent();
        this.lastStoredEvent = this.currentLunarEvent();
        String lunarEventNames = Arrays.toString(this.lunarEventSpawnRequirements.keySet().stream().map(Holder::m_203543_).map(Optional::orElseThrow).map(ResourceKey::m_135782_).map(ResourceLocation::toString).toArray());
        String dimension = level.m_46472_().m_135782_().toString();
        EnhancedCelestials.LOGGER.info("Possible lunar events for dimension \"%s\" are %s.".formatted(dimension, lunarEventNames));
    }

    public Holder<LunarDimensionSettings> getDimensionSettingsHolder() {
        return this.dimensionSettingsHolder;
    }

    public void loadData(Data data) {
        this.forecast.clear();
        this.forecast.addAll(data.forecast);
        this.pastEvents.clear();
        this.pastEvents.addAll(data.pastEvents);
        this.lastCheckedDay = data.lastCheckedDay;
        if (!this.level.f_46443_) {
            this.forecast.removeIf(lunarEventInstance -> {
                ResourceKey<LunarEvent> lunarEventKey;
                Registry lunarEvents = (Registry)this.level.m_9598_().m_6632_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
                return !lunarEvents.m_142003_(lunarEventKey = lunarEventInstance.getLunarEventKey()) || !lunarEvents.m_246971_(lunarEventKey).m_203633_();
            });
            this.pastEvents.removeIf(lunarEventInstance -> {
                ResourceKey<LunarEvent> lunarEventKey;
                Registry lunarEvents = (Registry)this.level.m_9598_().m_6632_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
                return !lunarEvents.m_142003_(lunarEventKey = lunarEventInstance.getLunarEventKey()) || !lunarEvents.m_246971_(lunarEventKey).m_203633_();
            });
        }
    }

    public Data saveData() {
        return new Data(this.forecast, this.pastEvents, this.lastCheckedDay);
    }

    public void tick() {
        if (this.blend < 1.0f) {
            this.blend += 0.01f;
        }
        if (this.currentLunarEvent() != this.lastTickEvent) {
            this.eventSwitched(this.lastTickEvent, this.currentLunarEvent());
        }
        this.lastTickEvent = this.level.m_46462_() ? (this.level.m_46471_() && ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).requiresClearSkies() ? this.defaultLunarEvent() : this.getLunarEventForDay(this.getCurrentDay())) : this.defaultLunarEvent();
    }

    public boolean switchingEvents() {
        return this.blend < 1.0f;
    }

    public void eventSwitched(Holder<LunarEvent> lastEvent, Holder<LunarEvent> nextEvent) {
        this.blend = 0.0f;
        this.lastStoredEvent = lastEvent;
    }

    public Holder<LunarEvent> lastLunarEvent() {
        return this.lastStoredEvent;
    }

    public Holder<LunarEvent> currentLunarEvent() {
        if (this.level.m_46461_()) {
            return this.defaultLunarEvent();
        }
        if (((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).requiresClearSkies() && this.level.m_46471_()) {
            return this.defaultLunarEvent();
        }
        Holder.Reference<LunarEvent> defaultEvent = this.defaultLunarEvent();
        if (this.forecast.isEmpty()) {
            return defaultEvent;
        }
        LunarEventInstance first = this.forecast.get(0);
        if (first.active(this.getCurrentDay())) {
            return this.lunarEventHolder(first.getLunarEventKey());
        }
        return defaultEvent;
    }

    public Holder<LunarEvent> nextScheduledLunarEvent() {
        if (this.forecast.isEmpty()) {
            return this.defaultLunarEvent();
        }
        LunarEventInstance first = this.forecast.get(0);
        if (first.active(this.getCurrentDay())) {
            LunarEventInstance second = this.forecast.get(1);
            return this.lunarEventHolder(second.getLunarEventKey());
        }
        return this.lunarEventHolder(first.getLunarEventKey());
    }

    public Holder<LunarEvent> lastScheduledLunarEvent() {
        Holder.Reference<LunarEvent> defaultEvent = this.defaultLunarEvent();
        if (this.pastEvents.isEmpty()) {
            return defaultEvent;
        }
        LunarEventInstance first = this.pastEvents.get(0);
        if (first.active(this.getCurrentDay())) {
            return this.lunarEventHolder(first.getLunarEventKey());
        }
        return defaultEvent;
    }

    public Holder<LunarEvent> getLunarEventForDay(long day) {
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            if (!lunarEventInstance.active(day)) continue;
            return this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
        }
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            if (!lunarEventInstance.active(day)) continue;
            return this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
        }
        return this.defaultLunarEvent();
    }

    public Component getForecastComponent() {
        MutableComponent textComponent = null;
        for (int i = Math.min(100, this.forecast.size() - 1); i >= 0; --i) {
            LunarEventInstance lunarEventInstance = this.forecast.get(i);
            Holder.Reference<LunarEvent> event = this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
            CustomTranslationTextComponent name = ((LunarEvent)event.m_203334_()).getTextComponents().name();
            TextColor color = name.getStyle().m_131135_();
            if (textComponent == null) {
                textComponent = Component.m_237115_((String)name.getKey()).m_130948_(Style.f_131099_.m_131148_(color));
            } else {
                textComponent.m_7220_((Component)Component.m_237113_((String)", ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))).m_7220_((Component)Component.m_237115_((String)name.getKey()).m_130948_(Style.f_131099_.m_131148_(color)));
            }
            textComponent.m_7220_((Component)Component.m_237110_((String)"enhancedcelestials.lunarforecast.days_left", (Object[])new Object[]{lunarEventInstance.getDaysUntil(this.getCurrentDay())}).m_130948_(Style.f_131099_.m_131148_(color)));
        }
        if (textComponent != null) {
            return Component.m_237110_((String)"enhancedcelestials.lunarforecast.header", (Object[])new Object[]{textComponent.m_7220_((Component)Component.m_237113_((String)".").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)))});
        }
        return Component.m_237110_((String)"enhancedcelestials.lunarforecast.empty", (Object[])new Object[]{textComponent}).m_130940_(ChatFormatting.YELLOW);
    }

    private Holder.Reference<LunarEvent> defaultLunarEvent() {
        return this.lunarEventHolder(((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).defaultEvent());
    }

    private Holder.Reference<LunarEvent> lunarEventHolder(ResourceKey<LunarEvent> lunarEventKey) {
        return ((Registry)this.level.m_9598_().m_6632_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow()).m_246971_(lunarEventKey);
    }

    public Object2LongArrayMap<ResourceKey<LunarEvent>> eventsByDay() {
        Object2LongArrayMap eventByLastTime = new Object2LongArrayMap();
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            eventByLastTime.put(lunarEventInstance.getLunarEventKey(), lunarEventInstance.scheduledDay());
        }
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            eventByLastTime.put(lunarEventInstance.getLunarEventKey(), lunarEventInstance.scheduledDay());
        }
        return eventByLastTime;
    }

    public long lastScheduledEventDay() {
        long lastScheduledEventDay = -1L;
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            lastScheduledEventDay = Math.max(lunarEventInstance.scheduledDay(), lastScheduledEventDay);
        }
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            lastScheduledEventDay = Math.max(lunarEventInstance.scheduledDay(), lastScheduledEventDay);
        }
        return lastScheduledEventDay;
    }

    public long getCurrentDay() {
        return this.getDayFromDayTime(this.level.m_46468_());
    }

    public long getDayFromDayTime(long dayTime) {
        return dayTime / ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).dayLength();
    }

    public long getDayTimeFromDay(long day) {
        return day * ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).dayLength();
    }

    public float getBlend() {
        return this.blend;
    }

    public record Data(List<LunarEventInstance> forecast, List<LunarEventInstance> pastEvents, long lastCheckedDay) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarEventInstance.CODEC.listOf().fieldOf("forecast").forGetter(Data::forecast), (App)LunarEventInstance.CODEC.listOf().fieldOf("past_events").forGetter(Data::pastEvents), (App)Codec.LONG.fieldOf("last_checked_day").forGetter(Data::lastCheckedDay)).apply((Applicative)builder, Data::new));
    }
}

